using System;
using System.Web.UI.WebControls;
using System.Web.UI;
using System.ComponentModel;
using System.ComponentModel.Design;
using AjaxControlToolkit;

[assembly: System.Web.UI.WebResource("ImageAnimation.ImageAnimationBehavior.js", 
    "text/javascript")
]

namespace ImageAnimation
{
    [Designer(typeof(ImageAnimationDesigner))]
    [
        ClientScriptResource("ImageAnimation.ImageAnimationBehavior", 
            "ImageAnimation.ImageAnimationBehavior.js")
    ]
    [RequiredScript(typeof(AnimationExtender))]
    [ToolboxItem("System.Web.UI.Design.WebControlToolboxItem, System.Design, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
    [TargetControlType(typeof(Image))]
    public class ImageAnimationExtender : AnimationExtenderControlBase
    {
        private Animation _onLoad;

        [DefaultValue(null)]
        [Browsable(false)]
        [ExtenderControlProperty]
        [
            DesignerSerializationVisibility(
                                       DesignerSerializationVisibility.Hidden)
        ]
        public new Animation OnLoad
        {
            get { return GetAnimation(ref _onLoad, "OnLoad"); }
            set { SetAnimation(ref _onLoad, "OnLoad", value); }
        }
    }
}
